'use client'

import { getResult } from "@/app/utils/app";
import { useEffect, useState } from "react";
import cookies from 'js-cookie';

// const fetchReult = async () => {
//     const result = await getResult('getToken()', 100);

//     return result.data;
// }

const Result = ({query}) => {
    const [results, setResults] = useState({
        result: [],
        GPA: '',
        CGPA: '',
        total_units: '',
        total_score: '',
        COD: ''
    })
    const token = cookies.get('student');

    // const total_units = results.reduce((acc, val) => acc + val.unit, 0)
    // const total_score = results.reduce((acc, val) => acc + val.grade, 0)

    useEffect(() => {
        const fetchResult = async () => {
            const response = await getResult(token, query);

            const result = response.data

            setResults(prev => ({
                ...prev,
                result: result.results,
                GPA: result.GPA,
                CGPA: result.CGPA,
                total_units: result.results.reduce((acc, val) => acc + val.unit, 0),
                total_score: result.results.reduce((acc, val) => acc + val.grade, 0),
                COD: result.COD
            }))
        }

        fetchResult()
    }, [query])

    return (
        <div className=''>
            {/* <h1 className=" xs:px-5 lg:px-16 text-3xl font-bold pb-5 pt-10">RESULT</h1> */}
            <h1 className="text-3xl font-bold pb-5 pt-10">RESULT</h1>

            {/* <div className='lg:flex lg:justify-center '> */}
            <div className='lg:flex'>
                <div className='lg:overflow-x-auto overflow-y-auto max-h-[500px] shadow-md mb-4 scrollable-section-hide'>
                    <table className='lg:max-w-full lg:min-w-[65rem] xs:min-w-16 divide-y divide-gray-300 shadow-md'>
                        <thead className='bg-gray-50 m-3 p-3 sticky top-0 z-10'>
                            <tr className=' text-orange-950 font-extralight  '>
                                <th scope='col' className='px-5 "lg:px-5  py-3 text-left  text-xs font-medium text-gray-500 uppercase  tracking-wider'>Course Code</th>
                                <th scope='col' className='px-12 lg:px-12  xs:px-20 py-3 text-left  text-xs font-medium text-gray-500 uppercase  tracking-wider' >Units</th>
                                <th scope='col' className='px-12 lg:px-12  xs:px-20 py-3 text-left  text-xs font-medium text-gray-500 uppercase  tracking-wider' >CA</th>
                                <th scope='col' className='px-12 lg:px-12  xs:px-20 py-3 text-left  text-xs font-medium text-gray-500 uppercase  tracking-wider' >Exam</th>
                                {query.semester && <th scope='col' className='px-10  text-left  text-xs font-medium text-gray-500 uppercase  tracking-wider'>Semster</th>}
                                <th scope='col' className='px-4 py-3 text-left  text-xs font-medium text-gray-500 uppercase  tracking-wider'>Score</th>
                            </tr>
                        </thead>

                        <tbody className=' bg-white max-w-full divide-y divide-gray-300'>
                            {results.result.map((course) => (
                                <tr key={course.code} className='text-orange-950 text-xs uppercase'>
                                    <td className='px-16 py-5 lg:px-12 lg:py-5 whitespace-normal'>
                                        <div>{course.code}</div>
                                    </td>
                                    <td className='px-1 lg:px-16 xs:px-20 py-2 whitespace-normal'>
                                        <div>{course.unit}</div>
                                    </td>
                                    <td className='px-1 lg:px-16 xs:px-20 py-2 whitespace-normal'>
                                        <div>{course.CA}</div>
                                    </td>
                                    <td className='px-1 lg:px-16 xs:px-20 py-2 whitespace-normal'>
                                        <div>{course.exam}</div>
                                    </td>
                                    {query.semester && <td className='px-14 py-2 whitespace-normal' >
                                        <div>{course.semester}</div>
                                    </td>}
                                    <td className='px-14 py-2 whitespace-normal' >
                                        <div>{course.grade}</div>
                                    </td>
                                </tr>
                            ))}
                            {/* <td className='px-14 py-2 whitespace-normal' >
                                <div>Total</div>
                            </td> */}
                        </tbody>

                        <tfoot className='bg-gray-50 m-3 p-3 sticky top-0 z-10'>
                            <tr className='text-orange-900 font-extralight'>
                                <th scope='col' className='px-5 lg:px-5  py-3 text-left  text-xs font-medium text-gray-500 uppercase  tracking-wider'>Total</th>
                                <th scope='col' className='px-12 lg:px-12  xs:px-20 py-3 text-left  text-xs font-medium text-gray-500 uppercase  tracking-wider' >{results.total_units}</th>
                                <th scope='col' className='px-12 lg:px-12  xs:px-20 py-3 text-left  text-xs font-medium text-gray-500 uppercase  tracking-wider' >{results.ca}</th>
                                <th scope='col' className='px-12 lg:px-12  xs:px-20 py-3 text-left  text-xs font-medium text-gray-500 uppercase  tracking-wider' >{results.exam}</th>
                                {query.semester && <th scope='col' className='px-10  text-left  text-xs font-medium text-gray-500 uppercase  tracking-wider'></th>}
                                <th scope='col' className='px-12 lg:px-12 py-3 text-left  text-xs font-medium text-gray-500 uppercase  tracking-wider'>{results.total_score}</th>
                            </tr>
                        </tfoot>

                    </table>
                </div>
            </div>

            {/* <div className="mt-12 flex justify-center items-center"> */}
            <div className="mt-5">
                <div className="max-w-md w-full bg-white shadow-lg rounded-lg overflow-hidden border border-orange-300">
                    <div className="p-6">
                        <h2 className="text-lg font-semibold text-orange-500 mb-4">Summary</h2>
                        <div className="space-y-2">
                            <div className="flex justify-between">
                                <h3 className="text-gray-700">Level:</h3>
                                <span className="text-orange-400">{results.result[0]?.level || 'N/A'}</span>
                            </div>
                            <div className="flex justify-between">
                                <h3 className="text-gray-700">GPA:</h3>
                                <span className="text-orange-400">{results.GPA}</span>
                            </div>
                            <div className="flex justify-between">
                                <h3 className="text-gray-700">CGPA:</h3>
                                <span className="text-orange-400">{results.CGPA}</span>
                            </div>
                            <div className="flex justify-between">
                                <h3 className="text-gray-700">Class of Diploma:</h3>
                                <span className="text-orange-400">{results.COD.class}</span>
                            </div>
                            <div className="flex justify-between">
                                <h3 className="text-gray-700">Session:</h3>
                                <span className="text-orange-400">2024/2025</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    )
}

export default Result