'use client'

import { getAcademicSessions } from '@/app/utils/app';
import { useEffect, useState } from 'react';
import Result from './Result';

const Filter = () => {
    const [sessions, setSessions] = useState([])
    const [query, setQuery] = useState({
        level: '',
        semester: '',
        session_id: ''
    })
    const [showResults, setShoowResults] = useState(false);

    useEffect(() => {
        const fetchSessions = async () => {
            const sessions = await getAcademicSessions();

            setSessions(sessions.data)
        }

        fetchSessions();
    }, [])

    const handleFilter = (e) => {
        const { name, value } = e.target;
        setQuery(prev => ({
            ...prev,
            [name]: value
        }))
    };

    console.log(query, 'query');

    return (
        <div className="container mx-auto p-4">
            <div className="mb-8">
                <div className="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label htmlFor="session_id" className="block text-sm font-medium text-gray-700">Session</label>
                        <select
                            id="session_id"
                            name="session_id"
                            value={query.session_id}
                            onChange={handleFilter}
                            className="mt-1 block w-full py-2 px-3 border border-gray-300 bg-white rounded-md shadow-sm focus:outline-none focus:ring-orange-500 focus:border-orange-500 sm:text-sm"
                        >
                            <option value="">Select Session</option>
                            {sessions.map(session => (
                                <option key={session.id} value={session.id}>{session.name}</option>
                            ))}
                        </select>
                    </div>
                    <div>
                        <label htmlFor="level" className="block text-sm font-medium text-gray-700">Level</label>
                        <select
                            id="level"
                            name="level"
                            value={query.level}
                            onChange={handleFilter}
                            className="mt-1 block w-full py-2 px-3 border border-gray-300 bg-white rounded-md shadow-sm focus:outline-none focus:ring-orange-500 focus:border-orange-500 sm:text-sm"
                        >
                            <option value="">Select Level</option>
                            {/* Populate these options based on your data */}
                            <option value="100">NID 1</option>
                            <option value="300">300 Level</option>
                        </select>
                    </div>
                    <div>
                        <label htmlFor="semester" className="block text-sm font-medium text-gray-700">Semester</label>
                        <select
                            id="semester"
                            name="semester"
                            value={query.semester}
                            onChange={handleFilter}
                            className="mt-1 block w-full py-2 px-3 border border-gray-300 bg-white rounded-md shadow-sm focus:outline-none focus:ring-orange-500 focus:border-orange-500 sm:text-sm"
                        >
                            <option value="">Select Semester</option>
                            <option value="first">First Semester</option>
                            <option value="second">Second Semester</option>
                        </select>
                    </div>
                </div>
                {!showResults && <button
                    onClick={() => setShoowResults(true)}
                    className="mt-4 px-4 py-2 bg-orange-500 text-white rounded hover:bg-orange-600"
                    disabled={!query.level || !query.semester}
                >
                    Show Results
                </button>}
            </div>
            {showResults && <Result query={query} />}
        </div>
    );
};

export default Filter;
