'use client'

import { verifyOutstandingFeePayment } from "@/app/utils/app";
import { useRouter, useSearchParams } from "next/navigation";
import { useEffect, useRef, useState } from "react";
import cookies from 'js-cookie';
import Preloader from "@/app/Preloader";
import { notify } from "@/app/utils/helper";


const page = () => {
    const searchParams = useSearchParams();
    const reference = searchParams.get('reference');
    const fee_ids = searchParams.get('fee_ids');
    const residual = searchParams.get('residual');
    const stream = searchParams.get('stream');
    const [status, setStatus] = useState(null);
    const router = useRouter();
    const ref = useRef(true);
    
    const token = cookies.get('student');
    
    useEffect(() => {
        const verify = async () => {
            try {
                const verification = await verifyOutstandingFeePayment(token, fee_ids, reference, residual)
                console.log(verification)
                if(verification.success) {
                    setStatus(verification.success)
                    // window.location.href = '/aspirant/professional/login';
                    router.replace('/student/fees')
                } else {
                    setStatus(false)
                }
                // const paid = cookies.set('paid', true);

            } catch (error) {
                console.log(error)
                if (error.response?.data?.errors) return notify('error', error.response.data.message)
                notify( 'error', error.message);
            }
        };

        if(ref.current) verify();

        return () => ref.current = false;
    }, []);

    return (
        <div>
            {status == true ?
                notify('success', 'Payment succesful')
                :
                status == false ?
                    <p>Verification failed</p> 
                    :
                <Preloader />
            }
        </div>
    )
}

export default page