
'use client'

import Summary from "./Summary";
import { useState } from "react";

const PayButton = ({ fees }) => {
    const [showModal, setShowModal] = useState(false);

    const handleClose = () => setShowModal(!showModal)
    
    return (
        <div className='flex gap-4 absolute bottom-5 right-3'>
            <button className='shadow-md w-32 h-10 rounded-md text-white bg-orange-500' onClick={() => setShowModal(!showModal)}>Pay</button>

            {showModal && <Summary fees={fees} onClose={handleClose} />}
        </div>
    )
}

export default PayButton