
import { getMyCourses, getMe } from '@/app/utils/app';
import { cookies } from 'next/headers';
import List from '../component/List';

export const dynamic = 'force-dynamic';

const getToken = () => cookies().get('student')?.value;

const getProfile = async () => {
    const std = await getMe(getToken());

    return std.data
}

const fetchMyCourses = async (stream) => {
    const courses = await getMyCourses(getToken())

    return courses.data
}

const page = async () => {
    const student = await getProfile();
    const courses = await fetchMyCourses(student.stream)

    console.log(courses)

    return (
            <div className='flex mt-12'>
                <div className='max-h-screen'>
                    <div className='absolute'>
                    <List student={student} courses={courses} token={getToken()} />
                        
                    </div>
                </div>

            </div>
    )
}

export default page