"use client"
import React, { useState } from 'react'
import { IoMdClose } from "react-icons/io";
import Preloader from '@/app/Preloader';
import CourseForm from './CourseForm';
import { dropCourse } from '@/app/utils/app';
import { notify } from '@/app/utils/helper';


function List({ student, courses, token }) {

    const [modal, setModal] = useState(false);


    const onClose = () => {
        setModal(!modal)
    };

    const handleDropCourse = async (id) => {
        const drop = await dropCourse(token, id);

        // if(!drop) throw new Error('Failed to drop course');

        notify('success', drop.message);
    }

    if (!courses.length) return (
        <div className='px-8'>
            <h1 className="text-3xl font-bold pb-5">My Courses</h1>
            <p>You're yet to register to do your course registration.</p>
        </div>
    )

    return (
        <div>
            <h1 className={`text-3xl font-bold pb-5 text-orange-950`}>My Courses</h1>

            <div className='flex justify-center lg:flex-nowrap flex-wrap'>
                <div className='overflow-x-auto overflow-y-auto max-h-[500px] w-full lg:w-[73rem] shadow-md mb-4 scrollable-section-hide'>
                    <table className='min-w-full lg:min-w-[73rem] divide-y divide-gray-300 shadow-md'>
                        <thead className='bg-gray-300 m-3 p-3 sticky top-0 z-10'>
                            <tr className=''>
                                <th scope='col' className='px-2 lg:px-5 py-3 text-left text-sm font-bold text-gray-500 uppercase tracking-wider'>Course Code</th>
                                <th scope='col' className='px-2 lg:px-52 py-3 text-left text-sm font-bold text-gray-500 uppercase tracking-wider'>Title</th>
                                <th scope='col' className='px-2 lg:px-12 py-3 text-left text-sm font-bold text-gray-500 uppercase tracking-wider'>Unit</th>
                                <th scope='col' className='px-2 lg:px-8 py-3 text-left text-sm font-bold text-gray-500 uppercase tracking-wider'>Actions</th>
                            </tr>
                        </thead>

                        <tbody className='bg-orange-400 divide-y divide-gray-300'>
                            {courses.map((course) => (
                                <tr key={course.code} className='text-orange-950 text-xs uppercase'>
                                    <td className='px-2 lg:px-12 py-2 whitespace-normal'>
                                        <div>{course.code}</div>
                                    </td>
                                    <td className='px-2 lg:px-44 py-2 whitespace-normal'>
                                        <div>{course.title}</div>
                                    </td>
                                    <td className='px-2 lg:px-16 py-2 whitespace-normal'>
                                        <div>{course.unit}</div>
                                    </td>
                                    <td className='px-2 lg:px-14 py-2 whitespace-normal'>
                                        <button className='bg-orange-500 w-14 h-8 rounded-md text-white' onClick={() => handleDropCourse(course.course_id)}>Drop</button>
                                    </td>
                                </tr>
                            ))}
                        </tbody>
                    </table>
                </div>
            </div>

            <div className={`pt-5 pb-5 ${courses.length ? 'block' : 'hidden'} absolute right-1`}>
                <button className='bg-orange-400 rounded-md p-1 text-white w-52 h-12 font-bold text-sm ease-in' onClick={() => setModal(true)}>Generate Course Form</button>
            </div>


            {/* {showPreloader && <Preloader />} */}
            {modal && <CourseForm onClose={onClose} />}

        </div>
    )
}

export default List;
