const SelectField = ({ name, label, options, onChange }) => (
    <div className="flex flex-col mb-4">
        <label htmlFor={name} className="pb-2">{label}:</label>
        <select
            name={name}
            id={name}
            className="bg-orange-200 outline-none border w-full rounded-md h-12 p-3"
            onChange={onChange}
            required
        >
            <option value="">Select {label}</option>
            {options.map((option, index) => (
                <option key={index} value={option}>{option.charAt(0).toUpperCase() + option.slice(1)}</option>
            ))}
        </select>
    </div>
);

export default SelectField