"use client"
import Link from 'next/link';
import { usePathname } from 'next/navigation';
import React, { Fragment } from 'react';
import { FaHome } from 'react-icons/fa';
import { IoIosArrowDown } from 'react-icons/io';
import { Popover, Transition } from '@headlessui/react';
import { GiBlackBook } from "react-icons/gi";
// import { CgProfile } from "react-icons/cg";
import { FaUser } from "react-icons/fa";
import { RiSecurePaymentFill } from "react-icons/ri";
import { MdSchool } from 'react-icons/md';



function Links() {
  const links = [
    { icon: FaHome, name: 'Home', href: '/student/dashboard' },
    { icon: GiBlackBook, name: 'Courses', href: '/courses', sublinks: [{name: 'My Courses  ',
    href : "/student/my_courses"}, {name: "Course Registration", href: "/student/courses"}] },
    { icon: RiSecurePaymentFill, name: 'Fees', href: '/student/fees',},
    { icon: MdSchool, name: 'Result', href: '/student/result' },
    { icon: FaUser, name: 'Profile', href: '/student/profile' },
  ];

  const pathname = usePathname();

  return (
    <div>
      <nav className='rounded-lg font-serif flex flex-col xs:gap-5 xs:pl-5  lg:max-h-[45rem] mt-4 w-60'>
        {links.map((item, i) => {
          const isActive = pathname === item.href;

          return (
            <Fragment key={item.name}>
              {item.sublinks ? (
                <Popover>
                  {({ open }) => (
                    <>
                      <Popover.Button
                        className={`${isActive && ' text-red-600 bg-slate-200 font-normal'} flex flex-row items-center lg:p-3 text-lg my-2 gap-4 text-black hover:text-orange-700 focus:outline-none`}
                      >
                        {<item.icon className='text-2xl' />}
                        {item.name}
                        <IoIosArrowDown className='ml-2' />
                      </Popover.Button>

                      <Transition
                        show={open}
                        enter='transition ease-out duration-100'
                        enterFrom='transform opacity-0 scale-95'
                        enterTo='transform opacity-100 scale-100'
                        leave='transition ease-in duration-75'
                        leaveFrom='transform opacity-100 scale-100'
                        leaveTo='transform opacity-0 scale-95'
                      >
                        <Popover.Panel static>
                          <div className='bg-white border flex flex-col rounded-md p-2 space-y-2'>
                            {item.sublinks.map((item, i) => (
                              <Link
                                href={item.href}
                                key={i}
                                className='text-gray-800 font-serif hover:text-orange-700 cursor-pointer'
                              >
                                {item.name}
                              </Link>
                            ))}
                          </div>
                        </Popover.Panel>
                      </Transition>
                    </>
                  )}
                </Popover>
              ) : (
                <Link
                  href={item.href}
                  key={item.name}
                  className={`${isActive && 'text-red-600 font-normal'} flex flex-row items-center lg:p-4 xs:pb-3 text-lg mt-2 gap-4 text-black hover:text-orange-700 `}
                >
                  {<item.icon className='text-2xl' />}
                  {item.name}
                </Link>
              )}
            </Fragment>
          );
        })}
      
      </nav>
    </div>
  );
}

export default Links;
