const InputField = ({ name, label, placeholder, type = "text", onChange, value = '', disabled = false, hideLabel = false }) => (
    <div className="flex flex-col mb-4">
        {!hideLabel && <label htmlFor={name} className="pb-2">{label}:</label>}
        <input
            type={type}
            name={name}
            id={name}
            className="bg-orange-200 outline-none border w-full rounded-md h-12 p-3"
            placeholder={placeholder}
            onChange={onChange}
            value={value}
            disabled={disabled}
            required
        />
    </div>
);

export default InputField;