const FileField = ({ name, label, onChange, error }) => (
    <div className="flex flex-col mb-4">
        <label htmlFor={name} className="pb-2">{label}:</label>
        <input
            type="file"
            name={name}
            className="bg-orange-200 outline-none border rounded-md h-12 p-3"
            onChange={onChange}
            accept="image/png, image/jpeg, image/jpg, application/pdf"
            required
        />
        {error && <p className="text-red-500 text-sm">{error}</p>}
    </div>
);

export default FileField;