import { useEffect, useState } from 'react'
import cookies from 'js-cookie';
import { redirect, useRouter } from 'next/navigation';
import { getProfPaymentLink, getProfFee } from '../utils/app'
import logo from "../img/logo.png"
import Image from 'next/image';
import Preloader from '../Preloader';

const FeeList = ({ formData }) => {
    const [fees, setFees] = useState([]);
    const [loader, setLoader] = useState(false)
    const router = useRouter()

    useEffect(() => {
        const getFee = async () => {
            const fees = await getProfFee(Number(formData.programme_id));
            setFees(fees.data)
        }

        getFee();
    }, []);

    const t = cookies.set('programme_id', formData.programme_id);
    console.log(cookies.get('programme_id'));
    console.log(fees)
    const handlePayment = async () => {
        try {
            const payment = await getProfPaymentLink(Number(formData.programme_id), formData);
            const t = cookies.set('programme_id', formData.programme_id);
            console.log(t)
            console.log(payment)
            console.log(payment.data.ref)
            // setTimeout(() => {
            // redirect(`${payment.data.url}`)
            // router.push(`${payment.data.url}`)
            window.location.href = payment.data.url;
            setTimeout(() => {

                setLoader((prev) => !prev);
            }, 2000)

            // }, 2000)

        } catch (error) {
            throw error;
        }
    };

    const handleBack = () => {
        router.back("/professional/apply")
        console.log("hello");
    }

    return (

        <div className='bg-white w-full'>
            <div className="pt-5 pb-4 px-4 text-center  ">
                <Image src={logo} className="w-44 mx-auto cursor-pointer " alt="Logo" />
                <p className="text-orange-500">TNM Media Academy</p>
            </div>
            <div className='bg-orange-500 min-h-screen font-serif'>

                <div className={`container mx-auto pt-12 flex justify-center  flex-col items-center`}>
                    <h1 className="text-3xl font-bold my-10 text-white">FEE</h1>
                    <table className="min-w-[75rem] divide-y rounded-md divide-gray-300 shadow-md">
                        <thead className='bg-gray-50 m-3 p-3'>
                            <tr>
                                <th className="p-5 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                                <th className="px-20 md:px-10 lg:px-20 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Description</th>
                                <th className="text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                                {/* <th className="px-8 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th> */}
                            </tr>
                        </thead>
                        <tbody className='bg-white max-w-full divide-y divide-gray-300'>
                            {fees.map((fee, index) => (
                                <tr key={index} className='text-slate-400 text-xs uppercase'>
                                    <td className="p-7 whitespace-normal">{index + 1}</td>
                                    <td className="px-20 md:px-10 lg:px-20 whitespace-normal">{fee.fee_description}</td>
                                    <td className="px-8 whitespace-normal">₦ {fee.amount}</td>
                                    {/* <td className={`px-10 whitespace-normal text-orange-500`}>
                                    {fee.status}
                                </td> */}
                                </tr>
                            ))}
                        </tbody>
                    </table>
                    <button className='absolute left-44 bottom-40 bg-white w-44 rounded-md h-10 text-xl  text-orange-500' onClick={handleBack}>Back</button>
                    <button className='absolute right-44 bottom-40 bg-white w-44 rounded-md h-10 text-xl  text-orange-500' onClick={handlePayment}>Pay</button>
                    {loader && <Preloader />}
                </div>
            </div>
        </div>
    )
}

export default FeeList;