import Image from "next/image"

import { cookies } from "next/headers"
import Link from "next/link";
import { getProfile } from "@/app/utils/app";
import jwt from 'jsonwebtoken'
import { redirect } from "next/navigation";

export const dynamic = 'force-dynamic';

const getMe = async (token) => {
    const user = await getProfile(token);

    return user.data;
}

const page = async () => {
    const token = cookies().get('prof_aspirant')?.value;
    console.log(jwt.decode(token));

    if(!token) redirect('/aspirant/professional/login')

    const profile = await getMe(token);

    return (
        <div className="bg-[#f3f3f3] min-h-screen flex flex-col items-center font-serif pb-32">
            {/* <div className="w-32 h-32 relative mb-5">
                <Image src={logo} alt="logo" layout="fill" objectFit="contain" />
            </div> */}
            <div className="bg-orange-300 min-w-[20rem] w-full max-w-xl rounded-lg shadow-lg mt-32 p-6">
                {profile ? (
                    <div className="space-y-4 text-orange-900">
                        <h3 className="text-3xl font-semibold text-left mb-12">Welcome, {profile.first_name}!</h3>
                        {profile.status === 'pending' && (
                            <p className="text-md text-center">Your application is currently being processed. Please keep checking back for updates.</p>
                        )}
                        {profile.status === 'accepted' && (
                            <div>
                                <p className="text-md">Congratulations, Your have been given admission to take a .</p>
                            <div className="mt-4 text-center">
                                <Link href='/aspirant/professional/fee' className="inline-block bg-orange-500 py-2 px-4 rounded hover:bg-orange-600 transition">
                                    Proceed to Payment
                                </Link>
                            </div>
                            </div>
                        )}
                        {profile.status !== 'pending' && profile.status !== 'accepted' && (
                            <div className="space-y-3">
                                <ul className="list-disc list-inside text-md">
                                    <li>
                                        <strong>Application Submission and Payment:</strong> After submitting your application and once your admission has been accepted, you will be prompted to make the necessary payment to finalize your admission process.
                                    </li>
                                    <li>
                                        <strong>Access Your Dashboard:</strong> Once the admission and payment process is complete, return to the main page and log in as a student. You will then be able to access your student dashboard where you can find all relevant information and resources.
                                    </li>
                                </ul>
                                <div className="text-center">
                                    <Link href='/aspirant/professional/apply' className="inline-block bg-orange-500 text-orange-900 py-2 px-4 rounded hover:bg-orange-600 transition">
                                        Apply
                                    </Link>
                                </div>
                            </div>
                        )}
                    </div>
                ) : (
                    <p className="text-md text-center">Unable to retrieve profile information. Please try again later.</p>
                )}
            </div>
        </div>
    );
}

export default page