// 'use client';

import logo from "@/app/img/logo.png"
import Image from 'next/image';
import { createAccount, getProgrammes } from '@/app/utils/app';
import { create } from "@/app/utils/_actions";
import { redirect } from "next/navigation";
import ApplicationForm from "../component/ApplicationForm";


const fetchProgrammes = async () => {
  const prog = await getProgrammes();

  return prog.data
}

async function Enroll() {

  const programmes = await fetchProgrammes();

  return (
    <div className='bg-[#f3f3f3] min-h-screen pt-32'>
      <div className='flex justify-center pt-4 pb-5'>
        <div className='shadow-md shadow-orange-900 bg-orange-300 rounded-md p-5 sm:h-auto sm:w-auto w-full max-w-4xl'>
          <div className='flex flex-col sm:flex-row justify-center'>
            {/* <Image src={logo} alt="logo" className='w-40 mb-5 sm:mb-0' /> */}
            <div className="text-orange-900">
              <h1 className='text-3xl font-semibold'>TNM Media Academy</h1>
              <p className='text-2xl font-semibold leading-snug'>Center For Media and Learning</p>
              <p className='pt-3'>...to think deep...</p>
            </div>
          </div>
          <ApplicationForm programmes={programmes} />
        </div>
      </div>
    </div>
  )
}

export default Enroll