'use client'

import { payTutionWithIDCardFee } from "@/app/utils/app"
import { useRouter } from "next/navigation";
import { useState, useTransition } from "react";

const TuitionPayButton = ({ token, stream, split }) => {
    const [isPending, startTransition] = useTransition();
    const [error, setError] = useState('');
    const router = useRouter();

    const pay = async () => {
            try {
                setError(null)
                const res = await payTutionWithIDCardFee(token, stream, split);
                console.log(res)
                router.replace(res.data.url);
            } catch (err) {
                console.error('Payment error:', err);
                setError('Payment failed due to an internal error. Please try again later.');
            }
        }
        
        return (
            <div>
            {/* <div className='flex gap-4 absolute bottom-5 right-3'> */}
                <button className='bg-white shadow-md w-32 h-10 rounded-md mr-3'>Cancel</button>
                <button className='shadow-md w-32 h-10 rounded-md text-orange-900 bg-orange-500 font-semibold' onClick={() => startTransition(pay)}>{isPending ? 'Processing...' : 'Pay'}</button>
            {/* </div> */}
            {error && <div className="text-red-500">{error}</div>}
        </div>
    )
}

export default TuitionPayButton;
