'use client'

import { payFormFee } from "@/app/utils/app";
import { useRouter } from "next/navigation";
import { useState, useTransition } from "react";

const FormPayButton = ({ data }) => {
    const [isPending, startTransition] = useTransition();
    const [error, setError] = useState('');
    const router = useRouter();

    const pay = async () => {
        try {
            setError('');
            const res = await payFormFee(data);
            console.log(res);
            router.replace(res.data.url);
        } catch (err) {
            console.error('Payment error:', err);
            setError('Payment failed due to an internal error. Please try again later.');
        }
    };

    return (
        <div className="text-center mt-4">
            <button className='shadow-lg mx-2 w-40 h-10 rounded-md text-white bg-orange-500 hover:bg-orange-600 font-semibold' onClick={() => startTransition(pay)}>
                {isPending ? 'Processing...' : 'Pay'}
            </button>
            <button className='shadow-lg mx-2 w-40 h-10 rounded-md'>Cancel</button>
            {error && <div className="text-red-500 mt-2">{error}</div>}
        </div>
    );
}

export default FormPayButton;
