import ProfApplicationForm from "@/app/forms/ProfessionalApplicationForm";
import { getProfFee, getProfile, getProgrammes } from "@/app/utils/app";
import { Suspense } from "react";
import Enroll from "../create/page";
import { cookies } from "next/headers";
import { redirect } from "next/navigation";

// export const dynamic = 'force-static'
// export const dynamic = 'force-dynamic'

const fetchProgramme = async () => {
  try {
    const programmes = await getProgrammes();

    if (!programmes) throw new Error('Could not fetch programmes')

    return programmes;
  } catch (error) {
    console.log(error);
  }
};

const getMe = async (token) => {
  const user = await getProfile(token);

  if(!token) redirect('/aspirant/professional/login')

  return user.data;
}

const page = async () => {
  const token = cookies().get('prof_aspirant')?.value
  const programmes = await fetchProgramme();
  const profile = await getMe(token);

  return (
    <div>
      <ProfApplicationForm programmes={programmes.data} data={profile} />
    </div>

  )
}

export default page;
