import Image from "next/image"
import { cookies } from "next/headers"
import Link from "next/link";
import { getProfile, getApplicationForm } from "@/app/utils/app";
import InfoCard from "./component/InfoCard";
import { redirect } from "next/navigation";
import FileDownloadButton from "./component/FileDownloadButton";

export const dynamic = 'force-dynamic';

const getMe = async (token) => {
    const user = await getProfile(token);

    return user.data;
}

const page = async () => {
    const token = cookies().get('aspirant')?.value;
    console.log(token)

    if (!token) redirect('/aspirant/nid/login')

    const profile = await getMe(token);
    console.log(profile)

    const serverdFile = async (fn) => {
        'use server';

        return await getApplicationForm(token);
    }

    return (
        <div className='bg-[#f3f3f3] min-h-screen flex flex-col items-center font-serif text-white pt-32'>
            {/* <div className="pt-5">
                <Image src={logo} alt="logo" width={160} height={160} />
            </div> */}
            {profile ? (
                <div className='flex flex-col  bg-orange-300 text-black w-full max-w-md rounded-md p-5 mt-10 min-h-72'>
                    {
                        profile.status === 'pending' && (
                            <>
                                <h3 className='text-2xl font-semibold text-orange-900'>Welcome, {profile.first_name}!</h3>
                                {profile.stream === 'part' && (
                                    <div>
                                        <p className="mt-4">Your application has been successfully processed! Please print a copy of your application form for submission at the JAMB office, and be sure to follow-up for further instructions. Thanks</p>
                                        <div className="border rounded-lg p-4 flex flex-col items-center justify-between mt-5">
                                            <h3 className="font-medium text-gray-800">Registration Form.pdf</h3>
                                            {/* <p className="text-sm text-gray-600">Size: ...</p> */}
                                            <FileDownloadButton fileFn={serverdFile} token={token} />
                                            {/* <FileDownloadButton token={token} /> */}
                                        </div>
                                    </div>
                                )}
                                {profile.stream === 'full' && <p className="mt-4">Your application is currently being processed. The screening date will be communicated soon. Please keep checking back for updates.</p>}
                            </>
                        )
                    }
                    {profile.status === 'accepted' && (
                        <InfoCard profile={profile} />
                    )}
                    {profile.status !== 'pending' && profile.status !== 'accepted' && (
                        <p>Unfortunately, you have not been given admission.</p>
                    )}
                </div>
            ) : <p>Unable to retrieve profile information. Please try again later.</p>
            }
        </div>
    );


    // BEFORE COMPLETE BYPASS (TO BE REVERTED BACK TO LATER)

}

export default page