'use client'

import logo from "@/app/img/logo.png"
import Image from 'next/image'
import cookies from 'js-cookie';
import { nidLogin, nidPartLogin } from '@/app/utils/app'
import { useRouter } from 'next/navigation'
import jwt from 'jsonwebtoken'
import { nLogin } from "@/app/utils/_actions";
import { useRef, useState, useTransition } from "react";
import { notify } from "@/app/utils/helper";

const page = () => {
  const [error, setError] = useState('');
  const [activeTab, setActiveTab] = useState('fulltime');
  const formRef = useRef();
  const router = useRouter();
  const [isPending, startTransition] = useTransition();

  const handleTabChange = (tab) => {
    setActiveTab(tab);
    setError('');

    if (formRef.current) {
      formRef.current.jamb_reg && (formRef.current.jamb_reg.value = '');
      formRef.current.email && (formRef.current.email.value = '');
      formRef.current.password.value = '';
    }
  };

  const handelsubmit = async (e) => {
    e.preventDefault();
    setError('');

    try {
      const loginData = activeTab === 'fulltime'
        ? { jamb_reg: formRef.current.jamb_reg?.value, password: formRef.current.password.value }
        : { email: formRef.current.email?.value, password: formRef.current.password.value };

      const res = activeTab === 'fulltime' ? await nidLogin(loginData) : await nidPartLogin(loginData);
      cookies.set('aspirant', res.data.token);

      if (res.success) window.location.href = '/aspirant/nid';
    } catch (error) {
      console.log(error.response);
      if (error.response?.data?.errors) return notify('error', error.response.data.message);
      notify('error', error.message);
    } finally {
      console.log('done');
    }
  };

  return (
    <div className='bg-[#f3f3f3] min-h-screen flex items-center justify-center font-serif'>
      <div className='bg-orange-300 w-full max-w-md mx-4 p-6 rounded-lg shadow-lg'>
        <div className='flex justify-around py-3 bg-orange-100 rounded-lg'>
          <button
            onClick={() => handleTabChange('fulltime')}
            className={`px-4 py-2 rounded ${activeTab === 'fulltime' ? 'bg-orange-500 text-white' : 'text-orange-500'}`}
          >
            Full-time
          </button>
          <button
            onClick={() => handleTabChange('parttime')}
            className={`px-4 py-2 rounded ${activeTab === 'parttime' ? 'bg-orange-500 text-white' : 'text-orange-500'}`}
          >
            Part-time
          </button>
        </div>

        <form ref={formRef} className='pt-5' onSubmit={(e) => startTransition(() => handelsubmit(e))}>
          <div className='flex flex-col'>
            {/* <h1 className='text-orange-500 text-4xl'>TNM Media Academy</h1> */}
            <h3 className='pt-4 text-2xl font-black text-orange-900 text-center'>Login</h3>
            {error && <div className="text-red-500 mt-2">{error}</div>}
            <div className='pt-4 flex flex-col'>
              {activeTab === 'fulltime' ? (
                <input type="text" name="jamb_reg" className='bg-orange-100 border w-full outline-none rounded-lg p-3 mb-4' placeholder='Jamb Registration No' />
              ) : (
                <input type="email" name="email" className='bg-orange-100 border w-full outline-none rounded-lg p-3 mb-4' placeholder='Email' />
              )}
              <input type="password" name="password" className='bg-orange-100 border w-full outline-none rounded-lg p-3' placeholder='Password' />
              <button type='submit' className='bg-orange-500 text-white cursor-pointer w-full rounded-lg mt-5 p-3'>
                {isPending ? 'Authenticating...' : 'Login'}
              </button>
            </div>
          </div>
          <div className='text-right mt-3'>
            <a href="#" className='text-orange-900 underline decoration-orange-500'>Forgot Password?</a>
          </div>
        </form>
      </div>
    </div>
  );
}

export default page;
