'use client'

import { verifyNIDTutionFeePayment } from "@/app/utils/app";
import { useRouter, useSearchParams } from "next/navigation";
import { useEffect, useRef, useState } from "react";
import cookies from 'js-cookie';
import Preloader from "@/app/Preloader";
import { notify } from "@/app/utils/helper";

const Page = () => {
    const searchParams = useSearchParams();
    const reference = searchParams.get('reference');
    const fee_ids = searchParams.get('fee_ids');
    const [status, setStatus] = useState('loading'); // Initialize status as 'loading'
    const router = useRouter();
    const ref = useRef(true)
    
    const token = cookies.get('aspirant');
    
    useEffect(() => {
        const verify = async () => {
            try {
                const verification = await verifyNIDTutionFeePayment(token, fee_ids, reference);
                console.log(verification);
                if(verification.success) {
                    setStatus('success'); // Update status to 'success'
                } else {
                    setStatus('failed'); // Update status to 'failed'
                }
            } catch (error) {
                console.error(error);
                setStatus('failed'); // Update status to 'failed'
                notify('error', error.response?.data?.message || error.message);
            }
        };

        if(ref.current) verify();

        return () => ref.current = false;
    }, [reference]);

    useEffect(() => {
        // Trigger side effects based on the status
        if (status === 'success') {
            notify('success', 'Payment successful');
            router.replace('/aspirant/nid');
        } else if (status === 'failed') {
            notify('error', 'Verification failed');
        }
    }, [status, router]);

    // Conditional rendering based on the status
    if (status === 'loading') {
        return <Preloader />;
    }

    return (
        <div>
            {status === 'failed' && <p>Verification failed</p>}
        </div>
    );
};

export default Page;
