'use client'

import { verifyNIDAcceptanceFeePayment } from "@/app/utils/app";
import { useRouter, useSearchParams } from "next/navigation";
import { useEffect, useRef, useState } from "react";
import cookies from 'js-cookie';
import Preloader from "@/app/Preloader";
import { notify } from "@/app/utils/helper";

const page = () => {
    const searchParams = useSearchParams();
    const reference = searchParams.get('reference');
    const fee_id = searchParams.get('fee_id');
    const [status, setStatus] = useState('loading'); // Initial state is 'loading'
    const router = useRouter();
    const token = cookies.get('aspirant');
    const ref = useRef(true)

    useEffect(() => {
        const verify = async () => {
            try {
                const verification = await verifyNIDAcceptanceFeePayment(token, fee_id, reference);
                if(verification.success) {
                    setStatus('success');
                } else {
                    setStatus('failed');
                }
            } catch (error) {
                setStatus('failed');
                notify('error', error.response?.data?.errors ? error.response.data.message : error.message);
            }
        };

        if(ref.current) verify();

        return () => ref.current = false;
    }, [reference]);

    useEffect(() => {
        if (status === 'success') {
            notify('success', 'Payment successful');
            router.replace('/aspirant/nid');
        } else if (status === 'failed') {
            notify('error', 'Verification failed');
        }
    }, [status]);

    if (status === 'loading') {
        return <Preloader />;
    }

    return (
        <div>
            {status === 'failed' ? <p>Verification failed</p> : null}
        </div>
    );
}

export default page;
