import { getPutmeFee } from "@/app/utils/app"
import PUTMEPayButton from "./PUTMEPayButton";
import Image from "next/image";
import logo from "@/app/img/logo.png"

const putmeFee = async () => {
    const fee = await getPutmeFee();

    return fee.data;
}

async function PUTMEScreeningFee({ formData, handleBack }) {
    const fee = await putmeFee();

    return (
        <div>
            <div className=''>
                <div>
                    <div className='flex justify-center items-center font-serif'>
                        <div className=' rounded-sm relative bg-orange-200 shadow min-h-[30rem] min-w-96 mt-48'>
                            <div className='flex  pt-5 flex-col justify-center items-center'>
                                {/* <Image alt='logo' src={logo} /> */}
                                <p className='text-orange-500 text-4xl'>TNM Media Academy</p>
                            </div>
                            <div>
                                <h1 className='text-center pt-5 text-xl text-orange-900 font-bold'>PUTME Screening Fee</h1>
                            </div>

                            <div className='pt-10 pl-8'>
                                <h5 className='text-orange-900 font-extralight'>Full Name: {formData.first_name} {formData.last_name}</h5>
                                <div className='flex flex-col pt-8 pl-3'>
                                    <div className='flex gap-2 text-orange-900 '>
                                        <div>
                                            <h3 className='font-bold'>Screening fee:</h3>
                                            <h3 className='font-bold'>Charges:</h3>
                                            <h3 className='pt-3 font-bold'>Total FEE:</h3>
                                        </div>
                                        <div className='flex flex-col gap-3 absolute right-4'>
                                            <p className='font-bold'>₦{fee.amount}</p>
                                            <p className='font-bold'>₦{fee.charges}</p>
                                            <p className='font-bold'>₦{fee.amount + fee.charges}</p>
                                        </div>
                                    </div>
                                </div>
                                <div className='border-b pt-14 w-80'></div>
                            </div>
                            <PUTMEPayButton data={formData} handleBack={handleBack} />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    )
}

export default PUTMEScreeningFee