'use client'

import { useState } from 'react';
import { registerAndPayPutmeFee } from "@/app/utils/app"
import { useRouter } from "next/navigation";
import { useTransition } from "react";
import { notify } from '@/app/utils/helper';

const PUTMEPayButton = ({ data, handleBack }) => {
  const [isPending, startTransition] = useTransition();
  const [error, setError] = useState('');
  const router = useRouter();

  const pay = async () => {
    try {
      const res = await registerAndPayPutmeFee(data);
      console.log(res)
      router.replace(res.data.url);
    } catch (err) {
      console.error('Payment error:', err);
      if (err.response.data.message) notify('error' ,err.response.data.message)
      else notify('error', 'Payment failed ☹️. Please try again later');
    }
  }

  return (
    <div>
      <div className='flex flex-col gap-4 absolute bottom-5 right-3'>
        <div className='flex gap-4'>
          <button className='shadow-md w-32 h-10 rounded-md' onClick={handleBack}>Back</button>
          <button className='shadow-md w-32 h-10 rounded-md text-white bg-orange-500' disabled={isPending} onClick={() => startTransition(pay)}>{isPending ? 'Processing...' : 'Pay'}</button>
          {/* <button className='shadow-md w-32 h-10 rounded-md text-white bg-orange-500' onClick={() => startTransition(processPayment)}>{isPending ? 'Processing...' : 'Pay'}</button> */}
        </div>
      </div>

      {error && <div className="text-red-500">{error}</div>}
    </div>
  )
}

export default PUTMEPayButton
