"use client"
import React, { useState } from 'react';
import Image from "next/image";
import cookies from 'js-cookie';
import BiodataSection from './BiodataSection';
import AdmissionSection from './AdmissionSection';
import FeeSection from './Fee';
import logo from '@/app/img/logo.png';
import { getPutmeFee, getPutmePaymentLink } from '@/app/utils/app';
import UploadAdmissionLetter from '@/app/forms/UploadAdmissionLetter';

function InfoCard({ profile }) {
    const [activeTab, setActiveTab] = useState('biodata');
    const [upload, setUpload] = useState(false);

    const toggleModal = () => setUpload(!upload);

    const onUploadClick = () => {
        toggleModal();
        setActiveTab('fee');
    }

    const tabList = [
        { id: 'biodata', title: 'Biodata' },
        { id: 'admission', title: 'Admission' },
        { id: 'fee', title: 'Fee' }
    ];

    const renderTabContent = () => {
        switch (activeTab) {
            case 'biodata':
                return <BiodataSection profile={profile} />;
            case 'admission':
                return <AdmissionSection profile={profile} onUploadClick={onUploadClick} />;
            case 'fee':
                return <FeeSection />;
            default:
                return <div>Tab Content Not Found</div>;
        }
    };

    return (
        <div className='bg-orange-300 rounded-lg shadow p-4 md:p-8 my-5 max-w-4xl w-full mx-auto'>
            <div className='flex border-b pb-4 mb-6'>
                {tabList.map(tab => (
                    <button
                        key={tab.id}
                        className={`mr-4 text-lg ${activeTab === tab.id ? 'font-bold text-orange-500 border-b-2 border-orange-500' : 'text-gray-500'}`}
                        onClick={() => setActiveTab(tab.id)}
                    >
                        {tab.title}
                    </button>
                ))}
            </div>
            <div>
                {renderTabContent()}
            </div>

            {upload && <UploadAdmissionLetter onClose={toggleModal} />}
        </div>
    );
}

export default InfoCard;
