'use client';

import { getApplicationForm } from "@/app/utils/app";
import { notify } from "@/app/utils/helper";

const downloadFile = async (token, fn) => {
    try {
        const {blob, filename} = await fn(token);
        // Check if blob is a valid Blob
        if (!(blob instanceof Blob)) {
            throw new TypeError('The returned value is not a valid Blob.');
        }
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.style.display = 'none';
        a.href = url;
        a.download = filename;
        document.body.appendChild(a);
        a.click();
        window.URL.revokeObjectURL(url);
    } catch (error) {
        notify('error', error)
        console.error('Download failed', error);
    }
};


const FileDownloadButton = ({ fileFn, token }) => {
    const handleDownload = (fn) => downloadFile(token, fn);

    return (
        // <button download className="mt-4 bg-orange-500 text-white py-2 px-4 rounded hover:bg-orange-600" onClick={() => downloadFile(token, fileFn)}>
        <button download className="mt-4 bg-orange-500 text-white py-2 px-4 rounded hover:bg-orange-600" onClick={() => downloadFile(token, getApplicationForm)}>
            Download
        </button>
    )
}

export default FileDownloadButton;