import React from 'react';
import { FaUser, FaEnvelope, FaBirthdayCake, FaGraduationCap } from 'react-icons/fa';
import { GiGraduateCap } from 'react-icons/gi';

function BiodataSection({ profile }) {
    return (
        <div>
            <h2 className="text-2xl font-semibold mb-4">Personal Information</h2>
            <div className="space-y-2">
                <div className="flex items-center">
                    <FaUser className="mr-2 text-orange-500" />
                    <p>{profile.first_name} {profile.last_name}</p>
                </div>
                <div className="flex items-center">
                    <FaEnvelope className="mr-2 text-orange-500" />
                    <p>{profile.email}</p>
                </div>
                <div className="flex items-center">
                    <FaBirthdayCake className="mr-2 text-orange-500" />
                    <p>{profile.birthdate}</p>
                </div>
                <div className="flex items-center">
                    <FaGraduationCap className="mr-2 text-orange-500" />
                    <p>{profile.jamb_reg}</p>
                </div>
            </div>
        </div>
    );
}

export default BiodataSection;
