"use client";
import { useState } from "react";
import Link from "next/link";

import PUTMEScreeningFee from '../../component/PUTMEScreeningFee'

function Page() {
  const [activeTab, setActiveTab] = useState("fulltime");
  const [showFee, setShowFee] = useState(false);
  const [formData, setFormData] = useState({
    first_name: "",
    last_name: "",
    middle_name: "",
    email: "",
    phone: "",
    DOB: "",
    gender: "",
    jamb_reg: "",
    jamb_result: "",
    o_level: "",
    lga: "",
    state_of_origin: "",
    address: "",
    passport: null,
    manualOlevelResults: [],
  });
  const [error, setError] = useState({ o_level: "", jamb_result: "", passport: "" });
console.log(formData, 'formData');

  const handleTabSwitch = (tab) => setActiveTab(tab);

  const handleFileChange = (e) => {
    const { name, files } = e.target;
    const file = files[0];
    const validTypes = ["image/png", "image/jpeg", "image/jpg", "application/pdf"];
    const maxSize = 500 * 1024;

    if (!file || !validTypes.includes(file.type) || file.size > maxSize) {
      setError((prev) => ({
        ...prev,
        [name]: file
          ? file.size > maxSize
            ? "File size must be less than 500 KB"
            : "Only PNG, JPG, JPEG, and PDF files are allowed"
          : "No file selected",
      }));
      e.target.value = "";
      return;
    }

    setFormData((prev) => ({ ...prev, [name]: file }));
    setError((prev) => ({ ...prev, [name]: "" }));
  };

  const handleChange = (e) => {
    const { name, value } = e.target;
    setFormData((prev) => ({ ...prev, [name]: value }));
  };

  const addOlevelResult = () => {
    setFormData((prev) => ({
      ...prev,
      manualOlevelResults: [...prev.manualOlevelResults, { subject: "", grade: "" }],
    }));
  };

  const handleOlevelChange = (index, field, value) => {
    const newResults = formData.manualOlevelResults.map((result, i) =>
      i === index ? { ...result, [field]: value } : result
    );
    setFormData((prev) => ({ ...prev, manualOlevelResults: newResults }));
  };

  const handleSubmit = (e) => {
    e.preventDefault();
    setShowFee(!showFee);
  };

  const handleBack = () => setShowFee(!showFee);

  return (
    <div className="bg-[#f3f3f3] flex justify-center min-h-screen p-4">
      <div className="shadow-lg bg-orange-300 rounded-md p-6 w-full max-w-3xl">
        <h1 className="font-bold mb-6 text-2xl text-center">Post UTME Screening Form</h1>
        <div className="flex mb-6 justify-center gap-8">
          <button
            className={`py-2 px-6 ${activeTab === "fulltime" ? "bg-orange-400 text-white" : "bg-orange-200 text-gray-600"}`}
            onClick={() => handleTabSwitch("fulltime")}
          >
            Full-Time
          </button>
          <button
            className={`py-2 px-6 ${activeTab === "parttime" ? "bg-orange-400 text-white" : "bg-orange-200 text-gray-600"}`}
            onClick={() => handleTabSwitch("parttime")}
          >
            Part-Time
          </button>
        </div>

        {!showFee ? (
          <form onSubmit={handleSubmit}>
            <div className="grid grid-cols-1 sm:grid-cols-2 gap-4">
              {/* Standard Fields */}
              <InputField name="first_name" label="First Name" onChange={handleChange} />
              <InputField name="last_name" label="Last Name" onChange={handleChange} />
              <InputField name="middle_name" label="Middle Name" onChange={handleChange} />
              <InputField name="email" label="Email Address" type="email" onChange={handleChange} />
              <InputField name="phone" label="Phone Number" type="tel" onChange={handleChange} />
              <InputField name="DOB" label="Date of Birth" type="date" onChange={handleChange} />
              <SelectField name="gender" label="Gender" options={["Male", "Female", "Other"]} onChange={handleChange} />
              <InputField name="state_of_origin" label="State of Origin" onChange={handleChange} />
              <InputField name="lga" label="LGA" onChange={handleChange} />
              <InputField name="address" label="Address" onChange={handleChange} />

              {/* Conditional Fields */}
              {activeTab === "fulltime" ? (
                <>
                  <InputField name="jamb_reg" label="JAMB Registration Number" onChange={handleChange} />
                  <FileField
                    name="jamb_result"
                    label="Upload JAMB Result"
                    onChange={handleFileChange}
                    error={error.jamb_result}
                  />
                  <FileField
                    name="o_level"
                    label="Upload O-Level Result"
                    onChange={handleFileChange}
                    error={error.o_level}
                  />
                </>
              ) : (
                <>
                  <FileField
                    name="passport"
                    label="Upload Passport"
                    onChange={handleFileChange}
                    error={error.passport}
                  />
                  <div className="col-span-2 mt-4">
                    <label className="font-semibold">O-Level Results:</label>
                    {formData.manualOlevelResults.map((result, index) => (
                      <div key={index} className="flex gap-4 mt-2">
                        <input
                          type="text"
                          placeholder="Subject"
                          value={result.subject}
                          onChange={(e) => handleOlevelChange(index, "subject", e.target.value)}
                          className="bg-orange-200 w-full p-2 rounded-md"
                        />
                        <input
                          type="text"
                          placeholder="Grade"
                          value={result.grade}
                          onChange={(e) => handleOlevelChange(index, "grade", e.target.value)}
                          className="bg-orange-200 w-full p-2 rounded-md"
                        />
                      </div>
                    ))}
                    <button
                      type="button"
                      onClick={addOlevelResult}
                      className="mt-3 text-blue-500 hover:underline flex items-center"
                    >
                      Add Subject
                    </button>
                  </div>
                </>
              )}
            </div>

            <div className="flex justify-center mt-6">
              <button type="submit" className="bg-orange-400 text-white px-10 py-2 rounded-md">Continue</button>
            </div>
            <div className="flex justify-end mt-3 gap-2">
              <p className="font-medium">Already applied?</p>
              <Link href="/aspirant/nid/login" className="underline decoration-orange-500">Login here</Link>
            </div>
          </form>
        ) : (
          <PUTMEScreeningFee formData={formData} handleBack={handleBack} />
        )}
      </div>
    </div>
  );
}

export default Page;

const InputField = ({ name, label, type = "text", onChange }) => (
  <div className="flex flex-col mb-4">
    <label htmlFor={name} className="pb-2">{label}:</label>
    <input
      type={type}
      name={name}
      id={name}
      className="bg-orange-200 outline-none border w-full rounded-md h-12 p-3"
      onChange={onChange}
      required
    />
  </div>
);

const SelectField = ({ name, label, options, onChange }) => (
  <div className="flex flex-col mb-4">
    <label htmlFor={name} className="pb-2">{label}:</label>
    <select
      name={name}
      id={name}
      className="bg-orange-200 outline-none border w-full rounded-md h-12 p-3"
      onChange={onChange}
      required
    >
      <option value="">Select {label}</option>
      {options.map((option, index) => (
        <option key={index} value={option}>{option}</option>
      ))}
    </select>
  </div>
);

const FileField = ({ name, label, onChange, error }) => (
  <div className="flex flex-col mb-4">
    <label htmlFor={name} className="pb-2">{label}:</label>
    <input
      type="file"
      name={name}
      className="bg-orange-200 outline-none border rounded-md h-12 p-3"
      onChange={onChange}
      accept="image/png, image/jpeg, image/jpg, application/pdf"
      required
    />
    {error && <p className="text-red-500 text-sm">{error}</p>}
  </div>
);












// "use client"
// import { useRef, useState } from 'react'
// import logo from "@/app/img/logo.png"
// import Image from 'next/image'
// import Validation from '@/app/component/Validation'
// import { test } from '@/app/utils/_actions'
// import PUTMEScreeningFee from '../../component/PUTMEScreeningFee'
// import Link from 'next/link'
// function page() {
//     const [showFee, setShowFee] = useState(false);
//     const [formData, setFormData] = useState({
//         first_name: "",
//         last_name: "",
//         middle_name: "",
//         email: "",
//         phone: "",
//         DOB: "",
//         gender: "",
//         jamb_reg: "",
//         jamb_result: '',
//         o_level: ''
//     });

//     console.log(formData)

//     const handleChange = (e) => {
//         const { name, value, files } = e.target;

//         console.log({ name, value, files })
//         if (name === 'o_level' || name === 'jamb_result') {

//             const file = files[0]

//             if (!file) {
//                 setError(prev => ({...prev, [name]: 'No file selected'}));
//                 return;
//             }

//             const validTypes = ['image/png', 'image/jpeg', 'image/jpg', 'application/pdf'];
//             const maxSize = 500 * 1024; // 500 KB in bytes

//             if (!validTypes.includes(file.type)) {
//                 setError(prev => ({...prev, [name]: 'Only PNG, JPG, JPEG and PDF files are allowed'}));
//                 // Clear the input field
//                 e.target.value = '';
//                 return;
//             }

//             if (file.size > maxSize) {
//                 setError(prev => ({...prev, [name]: 'File size must be less than 500 KB'}));
//                 // Clear the input field
//                 e.target.value = '';
//                 return;
//             }
//             setFormData(prev => ({
//                 ...prev,
//                 [name]: files[0]
//             }))
//         } else {
//             setFormData(prev => ({
//                 ...prev,
//                 [name]: value
//             }))
//         }
//     }

//     const handleSubmit = (e) => {
//         e.preventDefault();
//         setShowFee(!showFee);
//     }

//     const handleBack = () => setShowFee(!showFee);

//     const [error, setError] = useState({
//         "o_level": "",
//         jamb_result: ""
//     })
// console.log(error);
//     // const screeningReg = () => {
//     //     'use server'
//     // }

//     return (
//         <div>
//             <div className='bg-[#f3f3f3] flex justify-center min-h-screen'>
//                 <div className=''>

//                     {!showFee ? (
//                         <div className='shadow-lg bg-orange-300 rounded-sm p-4 sm:p-7 m-4 sm:m-32'>
//                             {/* <div className='flex flex-col justify-center items-center'> */}
//                             {/* <Image alt='logo' src={logo} /> */}
//                             {/* <p className='text-orange-500 pt-4'>TNM Media Academy</p> */}
//                             {/* </div> */}
//                             <h1 className='font-bold mb-5 text-2xl pt-3 text-center'>Post UTME Screening Form</h1>
//                             <form onSubmit={handleSubmit}>
//                                 <div className='grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 pt-10'>
//                                     <div className='flex flex-col'>
//                                         <label htmlFor="first_name" className='pb-2'>First Name:</label>
//                                         <input type="text" name='first_name' id='first_name' className='bg-orange-200 outline-none border w-full rounded-md h-12 p-3' value={formData.first_name} onChange={handleChange} required />
//                                         {error.fname && <p className='text-red-500'>{error.fname}</p>}
//                                     </div>
//                                     <div className='flex flex-col'>
//                                         <label htmlFor="last_name" className='pb-2'>Last Name:</label>
//                                         <input type="text" name='last_name' id='last_name' className='bg-orange-200 outline-none border w-full rounded-md h-12 p-3' value={formData.last_name} onChange={handleChange} required />
//                                         {error.lname && <p className='text-red-500'>{error.lname}</p>}
//                                     </div>
//                                     <div className='flex flex-col'>
//                                         <label htmlFor="middle_name" className='pb-2'>Middle Name:</label>
//                                         <input type="text" name='middle_name' id='middle_name' className='bg-orange-200 outline-none border w-full rounded-md h-12 p-3' value={formData.middle_name} onChange={handleChange} required />
//                                         {error.lname && <p className='text-red-500'>{error.lname}</p>}
//                                     </div>
//                                     <div className='flex flex-col'>
//                                         <label htmlFor="email" className='pb-2'>Enter Email:</label>
//                                         <input type="email" name='email' className='bg-orange-200 outline-none border w-full rounded-md h-12 p-3' value={formData.email} onChange={handleChange} required />
//                                     </div>
//                                     <div className='flex flex-col mt-5'>
//                                         <label htmlFor="phone" className=''>Phone Number</label>
//                                         <input type="number" name="phone" id="phone" className='bg-orange-200 border w-full outline-none rounded-lg  p-3' value={formData.phone} onChange={handleChange} required />
//                                     </div>
//                                     <div className='flex flex-col mt-5'>
//                                         <label htmlFor="DOB" className=''>Date Of birth</label>
//                                         <input type="date" name="DOB" id="DOB" className='bg-orange-200 border w-full outline-none rounded-lg  p-3' value={formData.DOB} onChange={handleChange} required />
//                                     </div>
//                                     <div className='flex flex-col mt-5'>
//                                         <label htmlFor="gender" className=''>Gender</label>
//                                         <select
//                                             className="w-full px-4 py-2 h-12 mt-1 bg-orange-200 text-gray-600 border rounded-lg outline-none focus:ring focus:ring-orange-200"
//                                             name="gender"
//                                             value={formData.gender}
//                                             onChange={handleChange}
//                                         >
//                                             <option className='bg-orange-200'>Gender</option>
//                                             <option value={'male'}>Male</option>
//                                             <option value={'female'}>Female</option>
//                                             <option value={'other'}>Other</option>
//                                         </select>
//                                     </div>
//                                     <div className='flex flex-col'>
//                                         <label htmlFor="jamb_reg" className='pb-2 pt-4'>Jamb Registration No:</label>
//                                         <input type="text" name='jamb_reg' className='bg-orange-200 outline-none border w-full rounded-md h-12 p-3' value={formData.jamb_reg} onChange={handleChange} required />
//                                         {error.jamb_reg_No && <p className='text-red-500'>{error.jamb_reg_No}</p>}
//                                     </div>
//                                     <div className='flex flex-col'>
//                                         <label htmlFor="o_level" className='pb-2 pt-4'>O'level Result:</label>
//                                         <input type="file" name='o_level' className='bg-orange-200 outline-none border w-full rounded-md h-12 p-3' onChange={handleChange} accept="image/png, image/jpeg, image/jpg, application/pdf" required />
//                                         <p className="text-red-500 font-bold mt-2">{error.o_level}</p>
//                                     </div>
//                                     <div className='flex flex-col'>
//                                         <label htmlFor="jamb_result" className='pb-2 pt-4'>Jamb Result:</label>
//                                         <input type="file" name='jamb_result' className='bg-orange-200 outline-none border w-full rounded-md h-12 p-3' onChange={handleChange} accept="image/png, image/jpeg, image/jpg, application/pdf" required />
//                                         <p className="text-red-500 font-bold mt-2">{error.jamb_result}</p>
//                                     </div>
//                                 </div>
//                                 <div className='flex justify-center mt-10'>
//                                     <button type='submit' className='bg-orange-400 text-white w-full sm:w-auto px-10 h-10 rounded-md'>Continue</button>
//                                 </div>
//                                 <div className='flex gap-2 pl-9 w-full text-orange-900 justify-end pt-3'>
//                                     <p className='font-medium'>Already applied?</p>
//                                     <Link href="/aspirant/nid/login" className='underline decoration-orange-500'>Login here</Link>
//                                 </div>
//                             </form>
//                         </div>
//                     )
//                         :
//                         // <PUTMEScreeningFee formData={formDataObj} handleBack={handleBack} />
//                         <PUTMEScreeningFee formData={formData} handleBack={handleBack} />
//                     }
//                 </div>
//             </div>
//         </div>
//     )
// }

// export default page